// Declare CustomObject class, which extends GraphicObject.
class FallingObject extends GraphicObject
{


    constructor(graphicAsset, parent, name)
    {
        // Call the super constructor
        super(graphicAsset, parent, name);

        // Shadow placeholder
        this.shadow = nc.addGraphicObject(nc.graphicAssets.WhiteBox, this, "shadow");
        this.masking.makeMasked([nc.maskGroups.MainMaskGroup], true);

        // // Shadow will appear behind cabinet
        this.shadow.masking.makeMasked([nc.maskGroups.MainMaskGroup], false);
        this.shadow.subLayer = -.9;

        // // Add impact animation
        this.impact = nc.constructDefs.Impact.add(this);
        // // Scales down the impact animation
        this.impact.scale.scaleByFactor(.5);
        // // Disables the animation, so it doesn't play automatically
        this.impact.disable();
        // // Sets Size of falling objects
        this.scale.scaleByFactor(.4);
        this.disable();
        // // Sets x positions of random falling objects to 8 different slots 
        this.fallingPositionX = [-350, -190, 0, 170, 380, 570, 740, 900];
    }


    setFallingObject(name)
    {
        // // Sets a variable that can be referenced on the object
        this.objectName = name;

        // // set graphic based on name, changes graphic
        this.graphicAsset = nc.graphicAssets[name];

        // // Calls Falling Objects Shadow assets
        this.shadow.graphicAsset = nc.graphicAssets[name + "_Shadow"];

        // //set random x position
        let index = Math.floor(Math.random() * this.fallingPositionX.length);
        this.position.x = this.fallingPositionX[index];

        // // Start falling Y and Z location
        this.position.y = 930;
        this.rotation.z = 0;

        this.visible = true;
        this.enable();

        this.fall();

    }

    fall()
    {
        this.position.swoop.y(-1010, 3 * pr.difficulty, undefined, this, "splat");
        this.rotation.swoop.z(360, 3 * pr.difficulty);
    }

    splat()
    {

        this.visible = false;
        this.impact.enable();
        this.impact.timelines.Splat.influence = 1;
        this.impact.timelines.Splat.playOnce(this, "disable");

        this.playSound(this.objectName);

    }

    playSound(name)
    {

        let index = Math.floor(Math.random() * 1);

        if (name === "Bottle Poison" || name === "Bottle Sauce")
        {
            nc.sounds["Break" + index].playOnce();
        }

        if (name === "Cube Cheese" || name === "Cylinder Pepperoni" || name === "Semicircle Pepper" || name === "Pointy Pepper" || name === "Torus Pineapple")
        {
            nc.sounds["Squish" + index].playOnce();
        }

        if (name === "Torus Saw" || name === "Pointy Knife")
        {
            nc.sounds["Clang" + index].playOnce();
        }

        if (name === "Cube Lego" || name === "Semicircle Teeth")
        {
            nc.sounds["Plastic" + index].playOnce();
        }

        if (name === "Cylinder Land mine")
        {
            nc.sounds.Explosion.playOnce();
        }
    }
}
